--[[---------------------------------------------------------------------------
	Chocolatier Two Port Data: Bombay
	Copyright (c) 2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Characters

DefineCharacter { name = "bom_marketkeep" }
DefineCharacter { name = "bom_shopkeep" }
DefineCharacter { name = "bom_other1keep" }
DefineCharacter { name = "bom_other2keep" }

-------------------------------------------------------------------------------
-- Port Definition

DefinePort
{
	name = "bombay",
	available = false,
	ambient="sfx/seaside_loop.ogg",

	layout =
	{
	
		-- Plane
		SpriteLayer { imagelist=portPlanes, scale=.3, time=10000,hold=8000,bounce=true,
			path={{-72,-19},{35,-27},{106,43},{441,62},{555,67},{695,61},{875,50},},},
			
		-- Clouds
		SpriteLayer { image="clouds_04", time=140000, loop=true, htile=true, path={{800,50},{700,50},{100,50},{0,50},}, },
		SpriteLayer { image="clouds_04", time=100000, loop=true, path={{1200,80},{700,80},{100,80},{-400,80}}, },
		
		
	
		-- Trains
		SpriteLayer { image="train_01", scale=.2, time=10000,wait=20000,bounce=true,
			path={{175,210},{253,221},{398,204},{492,186},},},
		
		SpriteLayer { image="bom_trainmask", x=348+102/2,y=170+45/2 },
		EmptyBuilding { name="bom_other1", character={"bom_other1keep"}, x=14+245/2,y=122+123/2 },	-- Shivaji Railway Terminus
		SpriteLayer { image="bom_railmask", ambient="sfx/other_loop.ogg", x=0+285/2,y=173+107/2 },
	
		Shop { name="bom_shop", character="bom_shopkeep", x=443+144/2,y=109+119/2 },
		SpriteLayer { image="bom_shopmask", x=415+163/2,y=219+44/2 },

		-- Ships
		SpriteLayer { image="boat_03", scale=0.5, time=60000,hold=15000,bounce=true,
			path={{405,261},{605,243},{756,244},{890,244},{891,223},{892,165},{892,-49}}, },
		
		SpriteLayer { imagelist=portBoats, scale=1.0, time=40000,hold=8000,bounce=true,
			path={{880,280},{750,280},{350,280},{300,280}} },
			
		SpriteLayer { image="bom_boatmask", x=458,y=330 },

		Market { name="bom_market", character="bom_marketkeep", x=78+286/2,y=141+242/2,
			inventory = { orange=true, almond=true, ginger = true, milk=true, sugar=true, } },
		SpriteLayer { image="bom_marketmask", x=0+426/2,y=172+252/2 },

		EmptyBuilding { name="bom_other2", character={"bom_other2keep"}, ambient="sfx/other_loop.ogg", x=492+260/2,y=4+388/2 },	-- Mumbadevi Temple
		
		--Foreground Misty cloud
		SpriteLayer { image="clouds_04", time=80000, loop=true, htile=true, path={{800,350},{700,350},{100,350},{0,350},}, },
		
		SpriteLayer { image="bom_templemask", x=470+330/2,y=197+330/2 },
	}
}
